package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dto.UserCountDTO;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.UserCount;
import gov.va.genisis2.util.Helper;

/**
 * @author Getaneh Kassahun
 * 
 */

public class UserCountConverterTest extends AbstractMockMvcTests {

	/** The userCountConverter. */
	private UserCountConverter userCountConverter;

	/** The userCount. */
	private UserCount userCount;

	/** Run before all test methods. */
	@Before
	public void setUp() {
		userCountConverter = new UserCountConverter();
	}

	/**
	 * To testPopulateUserCount_RoleTypeId1
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testPopulateUserCount_RoleTypeId1() throws GenisisServiceException {
		userCountConverter.populateUserCount(null, new Date());

		List<UserCount> listUserCount = new ArrayList<>(0);
		listUserCount.add(Helper.getUserCount());
		UserCountDTO userCountDTO = userCountConverter.populateUserCount(listUserCount, new Date());
		assertEquals(0, userCountDTO.getTotalUsers());
	}

	/**
	 * To testPopulateUserCount_RoleTypeId2
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testPopulateUserCount_RoleTypeId2() throws GenisisServiceException {

		List<UserCount> listUserCount = new ArrayList<>(0);
		userCount = Helper.getUserCount();
		userCount.setRoleTypeId(2);
		listUserCount.add(userCount);
		UserCountDTO userCountDTO = userCountConverter.populateUserCount(listUserCount, new Date());
		assertEquals(2, userCountDTO.getTotalUsers());
	}

	/**
	 * To testPopulateUserCount_RoleTypeId3
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testPopulateUserCount_RoleTypeId3() throws GenisisServiceException {

		List<UserCount> listUserCount = new ArrayList<>(0);
		userCount = Helper.getUserCount();
		userCount.setRoleTypeId(3);
		listUserCount.add(userCount);
		UserCountDTO userCountDTO = userCountConverter.populateUserCount(listUserCount, new Date());
		assertEquals(2, userCountDTO.getTotalUsers());
	}

	/**
	 * To testPopulateUserCount_RoleTypeId4
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testPopulateUserCount_RoleTypeId4() throws GenisisServiceException {

		List<UserCount> listUserCount = new ArrayList<>(0);
		userCount = Helper.getUserCount();
		userCount.setRoleTypeId(4);
		listUserCount.add(userCount);
		UserCountDTO userCountDTO = userCountConverter.populateUserCount(listUserCount, new Date());
		assertEquals(2, userCountDTO.getTotalUsers());
	}

	/**
	 * To testPopulateUserCount_Default
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testPopulateUserCount_Default() throws GenisisServiceException {

		List<UserCount> listUserCount = new ArrayList<>(0);
		userCount = Helper.getUserCount();
		userCount.setRoleTypeId(0);
		listUserCount.add(userCount);
		userCountConverter.populateUserCount(listUserCount, new Date());
	}

}
